		function [G, Z, P, wcT, wsT, Amax, Amin] = CA_POLES_HB_Z(wsT, Amin, N)	
		
		% 	Computes the poles, zeros, and gain constant for a digital half-band 
		%	Cauer filter as well as the new band edges and attenuations.
		
		% 	Toolbox for DIGITAL FILTERS USING MATLAB
		
		% 	Author: 		Lars Wanhammar, 2001-10-08
		% 	Modified by: 	
		% 	Version: 		1
		% 	Copyright:		by authors - not released for commercial use
		% 	Known bugs:		 		
		% 	Report bugs to:	Wanhammar@gmail.com
		
		% 	The algorithm is based on: L. Gaszi:  
		% 	Explicit Formuals for Lattice Wave Digital Filters, IEEE Trans. on 
		% 	Circuits and Systems, Vol. CAS-32, No. 1, January 1985, pp. 68-88.
		
		
		wsT_req = wsT;
		
		% N must be an integer
		if ~(abs(N-round(N)) < eps)
			error('N must be an integeer')  
			return
		end
		if mod(N, 2) == 0 | N < 3
			% disp([' Error  The filer order must be odd'])
			return
		end	
		Eps_s_min = sqrt(10^(0.1*Amin) - 1);
		Eps_p_max = 1/Eps_s_min;
		Amax = 10*log10(1 + Eps_p_max^2);
		Omega_s = tan(wsT_req/2);
		Omega_p = 1/Omega_s;
		% Determine bounds and select the passband and stopband ripples and stopband edge
		ro = Eps_s_min;	
		for n = 1:2
			ro = ro*ro + sqrt(ro^4 - 1);
		end
		x = 0.5*(2*ro)^(4/N);
		for n = 1:4
			x = sqrt(0.5*(x + 1/x));
		end
		wsT_min = 2*atan(x);	
		%====================  Selecting stopband edge  ====================
		% 	Select wsT_min <= wsT <= wsT_req
		%	disp(['Select ' num2str(wsT_mi) ' <= wsT <= ' num2str(wsT_req)])
		%	
		%	wsT = wsT_req ==> The whole design margin is allocated to the passband and stopband.
		%	wsT = wsT_min ==> The whole design margin is used to reduce the stopband edge.
		wsT = (wsT_min+wsT_req)/2;
		%========================================
		q(1) = Omega_s;
		for n = 0:3 
			q(n+2) = q(n+1)^2 + sqrt(q(n+1)^4 - 1);	
		end
		m(4) = 0.5*(2*q(5))^(N/2);
		for n = 3:-1:1
			m(n) = sqrt(0.5*(m(n+1) + 1/m(n+1)));
		end
		Eps_p_min = 1/m(1);	
		%====================  Selecting passband ripple  ====================
		%	Choose Eps so that:
		%	disp([num2str(Eps_p_min) ' <= Eps <= ' num2str(Eps_p_max)]);
		%	If Eps = Eps_p_min then the whole design margin is allocated to the passband.
		%	If Eps = Eps_p_max then the whole design margin is allocated to the  stopband.
		Eps_p_star = (Eps_p_min+Eps_p_max)/2;
		%========================================
		Eps_s_star = m(1);
		Amax = 10*log10(1 + Eps_p_star^2);	%	Passband ripple
		wcT = pi - wsT;						%	Passband edge, wcT, and stopband edge, wsT
		Amin = 10*log10(1 + Eps_s_star^2);	%	Stopband attenuation
		g(1) = 1/Eps_p_star + sqrt(1 + 1/Eps_p_star^2);
		for n = 1:2
			g(n+1) = m(n+1)*g(n) + sqrt(1 + (m(n+1)*g(n))^2);
		end
		w = -ones(1, 6);
		w(6) = (m(4)/g(3) + sqrt(1 + (m(4)/g(3))^2))^(1/N);
		for n = 1:(N-1)/2
			c(5,n) = q(5)/sin(n*pi/N);
			for jn = 4:-1:1
				c(jn,n) = (c(jn+1,n) + 1/c(jn+1,n))/(2*q(jn));
			end
			y(n+1) = 1/c(1,n);
			A(n) = 2/(1 + y(n+1)^2)*sqrt(1 - (q(1)^2 + 1/q(1)^2 - y(n+1)^2)*y(n+1)^2);
		end
		Z = [-1];		% Determine the transmission zeros
		for n = 1:(N-1)/2
			x = exp(i*2*atan(q(1)*Omega_p/y(n+1)));
			Z = [Z; x; x'];
		end
		P = [0];		% Determine the poles
		for n = 1:(N-1)/2
			x =  sqrt(-4*(2-A(n))/(2+A(n)))/2;
			P = [P; x; x'];
		end	
	
		G = real(prod(1-P))/real(prod(1-Z));
		%
		% Determine the reflection zeros
		%	Zref = [1];;	
		%	for n = 1:(N-1)/2
		%		zref = exp(i*2*atan(q(1)*Phi_p*y(n+1)))
		%	Zref = [Zref; x; x'];
		%	end
		
		
